﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/kafka/model/ControllerNodeInfo.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace Kafka {
namespace Model {

ControllerNodeInfo::ControllerNodeInfo(JsonView jsonValue) { *this = jsonValue; }

ControllerNodeInfo& ControllerNodeInfo::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("endpoints")) {
    Aws::Utils::Array<JsonView> endpointsJsonList = jsonValue.GetArray("endpoints");
    for (unsigned endpointsIndex = 0; endpointsIndex < endpointsJsonList.GetLength(); ++endpointsIndex) {
      m_endpoints.push_back(endpointsJsonList[endpointsIndex].AsString());
    }
    m_endpointsHasBeenSet = true;
  }
  return *this;
}

JsonValue ControllerNodeInfo::Jsonize() const {
  JsonValue payload;

  if (m_endpointsHasBeenSet) {
    Aws::Utils::Array<JsonValue> endpointsJsonList(m_endpoints.size());
    for (unsigned endpointsIndex = 0; endpointsIndex < endpointsJsonList.GetLength(); ++endpointsIndex) {
      endpointsJsonList[endpointsIndex].AsString(m_endpoints[endpointsIndex]);
    }
    payload.WithArray("endpoints", std::move(endpointsJsonList));
  }

  return payload;
}

}  // namespace Model
}  // namespace Kafka
}  // namespace Aws
