﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/kafka/model/CreateClusterRequest.h>

#include <utility>

using namespace Aws::Kafka::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String CreateClusterRequest::SerializePayload() const {
  JsonValue payload;

  if (m_brokerNodeGroupInfoHasBeenSet) {
    payload.WithObject("brokerNodeGroupInfo", m_brokerNodeGroupInfo.Jsonize());
  }

  if (m_rebalancingHasBeenSet) {
    payload.WithObject("rebalancing", m_rebalancing.Jsonize());
  }

  if (m_clientAuthenticationHasBeenSet) {
    payload.WithObject("clientAuthentication", m_clientAuthentication.Jsonize());
  }

  if (m_clusterNameHasBeenSet) {
    payload.WithString("clusterName", m_clusterName);
  }

  if (m_configurationInfoHasBeenSet) {
    payload.WithObject("configurationInfo", m_configurationInfo.Jsonize());
  }

  if (m_encryptionInfoHasBeenSet) {
    payload.WithObject("encryptionInfo", m_encryptionInfo.Jsonize());
  }

  if (m_enhancedMonitoringHasBeenSet) {
    payload.WithString("enhancedMonitoring", EnhancedMonitoringMapper::GetNameForEnhancedMonitoring(m_enhancedMonitoring));
  }

  if (m_openMonitoringHasBeenSet) {
    payload.WithObject("openMonitoring", m_openMonitoring.Jsonize());
  }

  if (m_kafkaVersionHasBeenSet) {
    payload.WithString("kafkaVersion", m_kafkaVersion);
  }

  if (m_loggingInfoHasBeenSet) {
    payload.WithObject("loggingInfo", m_loggingInfo.Jsonize());
  }

  if (m_numberOfBrokerNodesHasBeenSet) {
    payload.WithInteger("numberOfBrokerNodes", m_numberOfBrokerNodes);
  }

  if (m_tagsHasBeenSet) {
    JsonValue tagsJsonMap;
    for (auto& tagsItem : m_tags) {
      tagsJsonMap.WithString(tagsItem.first, tagsItem.second);
    }
    payload.WithObject("tags", std::move(tagsJsonMap));
  }

  if (m_storageModeHasBeenSet) {
    payload.WithString("storageMode", StorageModeMapper::GetNameForStorageMode(m_storageMode));
  }

  return payload.View().WriteReadable();
}
