﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/kafka/model/UpdateMonitoringRequest.h>

#include <utility>

using namespace Aws::Kafka::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String UpdateMonitoringRequest::SerializePayload() const {
  JsonValue payload;

  if (m_currentVersionHasBeenSet) {
    payload.WithString("currentVersion", m_currentVersion);
  }

  if (m_enhancedMonitoringHasBeenSet) {
    payload.WithString("enhancedMonitoring", EnhancedMonitoringMapper::GetNameForEnhancedMonitoring(m_enhancedMonitoring));
  }

  if (m_openMonitoringHasBeenSet) {
    payload.WithObject("openMonitoring", m_openMonitoring.Jsonize());
  }

  if (m_loggingInfoHasBeenSet) {
    payload.WithObject("loggingInfo", m_loggingInfo.Jsonize());
  }

  return payload.View().WriteReadable();
}
