﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/HashingUtils.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/kinesis/model/PutRecordRequest.h>

#include <utility>

using namespace Aws::Kinesis::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String PutRecordRequest::SerializePayload() const {
  JsonValue payload;

  if (m_streamNameHasBeenSet) {
    payload.WithString("StreamName", m_streamName);
  }

  if (m_dataHasBeenSet) {
    payload.WithString("Data", HashingUtils::Base64Encode(m_data));
  }

  if (m_partitionKeyHasBeenSet) {
    payload.WithString("PartitionKey", m_partitionKey);
  }

  if (m_explicitHashKeyHasBeenSet) {
    payload.WithString("ExplicitHashKey", m_explicitHashKey);
  }

  if (m_sequenceNumberForOrderingHasBeenSet) {
    payload.WithString("SequenceNumberForOrdering", m_sequenceNumberForOrdering);
  }

  if (m_streamARNHasBeenSet) {
    payload.WithString("StreamARN", m_streamARN);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection PutRecordRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "Kinesis_20131202.PutRecord"));
  return headers;
}

PutRecordRequest::EndpointParameters PutRecordRequest::GetEndpointContextParams() const {
  EndpointParameters parameters;
  // Static context parameters
  parameters.emplace_back(Aws::String("OperationType"), "data", Aws::Endpoint::EndpointParameter::ParameterOrigin::STATIC_CONTEXT);
  // Operation context parameters
  if (StreamARNHasBeenSet()) {
    parameters.emplace_back(Aws::String("StreamARN"), this->GetStreamARN(),
                            Aws::Endpoint::EndpointParameter::ParameterOrigin::OPERATION_CONTEXT);
  }
  return parameters;
}
