﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/kinesis/model/UpdateShardCountResult.h>

#include <utility>

using namespace Aws::Kinesis::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

UpdateShardCountResult::UpdateShardCountResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

UpdateShardCountResult& UpdateShardCountResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("StreamName")) {
    m_streamName = jsonValue.GetString("StreamName");
    m_streamNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("CurrentShardCount")) {
    m_currentShardCount = jsonValue.GetInteger("CurrentShardCount");
    m_currentShardCountHasBeenSet = true;
  }
  if (jsonValue.ValueExists("TargetShardCount")) {
    m_targetShardCount = jsonValue.GetInteger("TargetShardCount");
    m_targetShardCountHasBeenSet = true;
  }
  if (jsonValue.ValueExists("StreamARN")) {
    m_streamARN = jsonValue.GetString("StreamARN");
    m_streamARNHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
