﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/kinesisanalytics/model/AddApplicationCloudWatchLoggingOptionRequest.h>

#include <utility>

using namespace Aws::KinesisAnalytics::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String AddApplicationCloudWatchLoggingOptionRequest::SerializePayload() const {
  JsonValue payload;

  if (m_applicationNameHasBeenSet) {
    payload.WithString("ApplicationName", m_applicationName);
  }

  if (m_currentApplicationVersionIdHasBeenSet) {
    payload.WithInt64("CurrentApplicationVersionId", m_currentApplicationVersionId);
  }

  if (m_cloudWatchLoggingOptionHasBeenSet) {
    payload.WithObject("CloudWatchLoggingOption", m_cloudWatchLoggingOption.Jsonize());
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection AddApplicationCloudWatchLoggingOptionRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "KinesisAnalytics_20150814.AddApplicationCloudWatchLoggingOption"));
  return headers;
}
