﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/kinesisanalytics/model/DestinationSchema.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace KinesisAnalytics {
namespace Model {

DestinationSchema::DestinationSchema(JsonView jsonValue) { *this = jsonValue; }

DestinationSchema& DestinationSchema::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("RecordFormatType")) {
    m_recordFormatType = RecordFormatTypeMapper::GetRecordFormatTypeForName(jsonValue.GetString("RecordFormatType"));
    m_recordFormatTypeHasBeenSet = true;
  }
  return *this;
}

JsonValue DestinationSchema::Jsonize() const {
  JsonValue payload;

  if (m_recordFormatTypeHasBeenSet) {
    payload.WithString("RecordFormatType", RecordFormatTypeMapper::GetNameForRecordFormatType(m_recordFormatType));
  }

  return payload;
}

}  // namespace Model
}  // namespace KinesisAnalytics
}  // namespace Aws
