﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/lex-models/model/ConversationLogsResponse.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace LexModelBuildingService {
namespace Model {

ConversationLogsResponse::ConversationLogsResponse(JsonView jsonValue) { *this = jsonValue; }

ConversationLogsResponse& ConversationLogsResponse::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("logSettings")) {
    Aws::Utils::Array<JsonView> logSettingsJsonList = jsonValue.GetArray("logSettings");
    for (unsigned logSettingsIndex = 0; logSettingsIndex < logSettingsJsonList.GetLength(); ++logSettingsIndex) {
      m_logSettings.push_back(logSettingsJsonList[logSettingsIndex].AsObject());
    }
    m_logSettingsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("iamRoleArn")) {
    m_iamRoleArn = jsonValue.GetString("iamRoleArn");
    m_iamRoleArnHasBeenSet = true;
  }
  return *this;
}

JsonValue ConversationLogsResponse::Jsonize() const {
  JsonValue payload;

  if (m_logSettingsHasBeenSet) {
    Aws::Utils::Array<JsonValue> logSettingsJsonList(m_logSettings.size());
    for (unsigned logSettingsIndex = 0; logSettingsIndex < logSettingsJsonList.GetLength(); ++logSettingsIndex) {
      logSettingsJsonList[logSettingsIndex].AsObject(m_logSettings[logSettingsIndex].Jsonize());
    }
    payload.WithArray("logSettings", std::move(logSettingsJsonList));
  }

  if (m_iamRoleArnHasBeenSet) {
    payload.WithString("iamRoleArn", m_iamRoleArn);
  }

  return payload;
}

}  // namespace Model
}  // namespace LexModelBuildingService
}  // namespace Aws
