﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/lex-models/model/GetSlotTypesResult.h>

#include <utility>

using namespace Aws::LexModelBuildingService::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

GetSlotTypesResult::GetSlotTypesResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

GetSlotTypesResult& GetSlotTypesResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("slotTypes")) {
    Aws::Utils::Array<JsonView> slotTypesJsonList = jsonValue.GetArray("slotTypes");
    for (unsigned slotTypesIndex = 0; slotTypesIndex < slotTypesJsonList.GetLength(); ++slotTypesIndex) {
      m_slotTypes.push_back(slotTypesJsonList[slotTypesIndex].AsObject());
    }
    m_slotTypesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("nextToken")) {
    m_nextToken = jsonValue.GetString("nextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
