﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/lexv2-models/model/AnalyticsUtteranceMetricResult.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace LexModelsV2 {
namespace Model {

AnalyticsUtteranceMetricResult::AnalyticsUtteranceMetricResult(JsonView jsonValue) { *this = jsonValue; }

AnalyticsUtteranceMetricResult& AnalyticsUtteranceMetricResult::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("name")) {
    m_name = AnalyticsUtteranceMetricNameMapper::GetAnalyticsUtteranceMetricNameForName(jsonValue.GetString("name"));
    m_nameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("statistic")) {
    m_statistic = AnalyticsMetricStatisticMapper::GetAnalyticsMetricStatisticForName(jsonValue.GetString("statistic"));
    m_statisticHasBeenSet = true;
  }
  if (jsonValue.ValueExists("value")) {
    m_value = jsonValue.GetDouble("value");
    m_valueHasBeenSet = true;
  }
  return *this;
}

JsonValue AnalyticsUtteranceMetricResult::Jsonize() const {
  JsonValue payload;

  if (m_nameHasBeenSet) {
    payload.WithString("name", AnalyticsUtteranceMetricNameMapper::GetNameForAnalyticsUtteranceMetricName(m_name));
  }

  if (m_statisticHasBeenSet) {
    payload.WithString("statistic", AnalyticsMetricStatisticMapper::GetNameForAnalyticsMetricStatistic(m_statistic));
  }

  if (m_valueHasBeenSet) {
    payload.WithDouble("value", m_value);
  }

  return payload;
}

}  // namespace Model
}  // namespace LexModelsV2
}  // namespace Aws
