﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/lexv2-models/model/ListBuiltInIntentsResult.h>

#include <utility>

using namespace Aws::LexModelsV2::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListBuiltInIntentsResult::ListBuiltInIntentsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListBuiltInIntentsResult& ListBuiltInIntentsResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("builtInIntentSummaries")) {
    Aws::Utils::Array<JsonView> builtInIntentSummariesJsonList = jsonValue.GetArray("builtInIntentSummaries");
    for (unsigned builtInIntentSummariesIndex = 0; builtInIntentSummariesIndex < builtInIntentSummariesJsonList.GetLength();
         ++builtInIntentSummariesIndex) {
      m_builtInIntentSummaries.push_back(builtInIntentSummariesJsonList[builtInIntentSummariesIndex].AsObject());
    }
    m_builtInIntentSummariesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("nextToken")) {
    m_nextToken = jsonValue.GetString("nextToken");
    m_nextTokenHasBeenSet = true;
  }
  if (jsonValue.ValueExists("localeId")) {
    m_localeId = jsonValue.GetString("localeId");
    m_localeIdHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
