﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/lexv2-models/model/ListExportsRequest.h>

#include <utility>

using namespace Aws::LexModelsV2::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String ListExportsRequest::SerializePayload() const {
  JsonValue payload;

  if (m_botIdHasBeenSet) {
    payload.WithString("botId", m_botId);
  }

  if (m_botVersionHasBeenSet) {
    payload.WithString("botVersion", m_botVersion);
  }

  if (m_sortByHasBeenSet) {
    payload.WithObject("sortBy", m_sortBy.Jsonize());
  }

  if (m_filtersHasBeenSet) {
    Aws::Utils::Array<JsonValue> filtersJsonList(m_filters.size());
    for (unsigned filtersIndex = 0; filtersIndex < filtersJsonList.GetLength(); ++filtersIndex) {
      filtersJsonList[filtersIndex].AsObject(m_filters[filtersIndex].Jsonize());
    }
    payload.WithArray("filters", std::move(filtersJsonList));
  }

  if (m_maxResultsHasBeenSet) {
    payload.WithInteger("maxResults", m_maxResults);
  }

  if (m_nextTokenHasBeenSet) {
    payload.WithString("nextToken", m_nextToken);
  }

  if (m_localeIdHasBeenSet) {
    payload.WithString("localeId", m_localeId);
  }

  return payload.View().WriteReadable();
}
