﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/lexv2-models/model/ListIntentsResult.h>

#include <utility>

using namespace Aws::LexModelsV2::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListIntentsResult::ListIntentsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListIntentsResult& ListIntentsResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("botId")) {
    m_botId = jsonValue.GetString("botId");
    m_botIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("botVersion")) {
    m_botVersion = jsonValue.GetString("botVersion");
    m_botVersionHasBeenSet = true;
  }
  if (jsonValue.ValueExists("localeId")) {
    m_localeId = jsonValue.GetString("localeId");
    m_localeIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("intentSummaries")) {
    Aws::Utils::Array<JsonView> intentSummariesJsonList = jsonValue.GetArray("intentSummaries");
    for (unsigned intentSummariesIndex = 0; intentSummariesIndex < intentSummariesJsonList.GetLength(); ++intentSummariesIndex) {
      m_intentSummaries.push_back(intentSummariesJsonList[intentSummariesIndex].AsObject());
    }
    m_intentSummariesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("nextToken")) {
    m_nextToken = jsonValue.GetString("nextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
