﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/lexv2-models/model/ListTestExecutionsResult.h>

#include <utility>

using namespace Aws::LexModelsV2::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListTestExecutionsResult::ListTestExecutionsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListTestExecutionsResult& ListTestExecutionsResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("testExecutions")) {
    Aws::Utils::Array<JsonView> testExecutionsJsonList = jsonValue.GetArray("testExecutions");
    for (unsigned testExecutionsIndex = 0; testExecutionsIndex < testExecutionsJsonList.GetLength(); ++testExecutionsIndex) {
      m_testExecutions.push_back(testExecutionsJsonList[testExecutionsIndex].AsObject());
    }
    m_testExecutionsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("nextToken")) {
    m_nextToken = jsonValue.GetString("nextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
