﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/lexv2-models/model/ListTestSetRecordsResult.h>

#include <utility>

using namespace Aws::LexModelsV2::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListTestSetRecordsResult::ListTestSetRecordsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListTestSetRecordsResult& ListTestSetRecordsResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("testSetRecords")) {
    Aws::Utils::Array<JsonView> testSetRecordsJsonList = jsonValue.GetArray("testSetRecords");
    for (unsigned testSetRecordsIndex = 0; testSetRecordsIndex < testSetRecordsJsonList.GetLength(); ++testSetRecordsIndex) {
      m_testSetRecords.push_back(testSetRecordsJsonList[testSetRecordsIndex].AsObject());
    }
    m_testSetRecordsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("nextToken")) {
    m_nextToken = jsonValue.GetString("nextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
