﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/lexv2-models/model/TestSetDiscrepancyReportBotAliasTarget.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace LexModelsV2 {
namespace Model {

TestSetDiscrepancyReportBotAliasTarget::TestSetDiscrepancyReportBotAliasTarget(JsonView jsonValue) { *this = jsonValue; }

TestSetDiscrepancyReportBotAliasTarget& TestSetDiscrepancyReportBotAliasTarget::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("botId")) {
    m_botId = jsonValue.GetString("botId");
    m_botIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("botAliasId")) {
    m_botAliasId = jsonValue.GetString("botAliasId");
    m_botAliasIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("localeId")) {
    m_localeId = jsonValue.GetString("localeId");
    m_localeIdHasBeenSet = true;
  }
  return *this;
}

JsonValue TestSetDiscrepancyReportBotAliasTarget::Jsonize() const {
  JsonValue payload;

  if (m_botIdHasBeenSet) {
    payload.WithString("botId", m_botId);
  }

  if (m_botAliasIdHasBeenSet) {
    payload.WithString("botAliasId", m_botAliasId);
  }

  if (m_localeIdHasBeenSet) {
    payload.WithString("localeId", m_localeId);
  }

  return payload;
}

}  // namespace Model
}  // namespace LexModelsV2
}  // namespace Aws
