﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/lightsail/model/AttachedDisk.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace Lightsail {
namespace Model {

AttachedDisk::AttachedDisk(JsonView jsonValue) { *this = jsonValue; }

AttachedDisk& AttachedDisk::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("path")) {
    m_path = jsonValue.GetString("path");
    m_pathHasBeenSet = true;
  }
  if (jsonValue.ValueExists("sizeInGb")) {
    m_sizeInGb = jsonValue.GetInteger("sizeInGb");
    m_sizeInGbHasBeenSet = true;
  }
  return *this;
}

JsonValue AttachedDisk::Jsonize() const {
  JsonValue payload;

  if (m_pathHasBeenSet) {
    payload.WithString("path", m_path);
  }

  if (m_sizeInGbHasBeenSet) {
    payload.WithInteger("sizeInGb", m_sizeInGb);
  }

  return payload;
}

}  // namespace Model
}  // namespace Lightsail
}  // namespace Aws
