﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/lightsail/model/ContainerImage.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace Lightsail {
namespace Model {

ContainerImage::ContainerImage(JsonView jsonValue) { *this = jsonValue; }

ContainerImage& ContainerImage::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("image")) {
    m_image = jsonValue.GetString("image");
    m_imageHasBeenSet = true;
  }
  if (jsonValue.ValueExists("digest")) {
    m_digest = jsonValue.GetString("digest");
    m_digestHasBeenSet = true;
  }
  if (jsonValue.ValueExists("createdAt")) {
    m_createdAt = jsonValue.GetDouble("createdAt");
    m_createdAtHasBeenSet = true;
  }
  return *this;
}

JsonValue ContainerImage::Jsonize() const {
  JsonValue payload;

  if (m_imageHasBeenSet) {
    payload.WithString("image", m_image);
  }

  if (m_digestHasBeenSet) {
    payload.WithString("digest", m_digest);
  }

  if (m_createdAtHasBeenSet) {
    payload.WithDouble("createdAt", m_createdAt.SecondsWithMSPrecision());
  }

  return payload;
}

}  // namespace Model
}  // namespace Lightsail
}  // namespace Aws
