﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/lightsail/model/DeleteBucketAccessKeyRequest.h>

#include <utility>

using namespace Aws::Lightsail::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String DeleteBucketAccessKeyRequest::SerializePayload() const {
  JsonValue payload;

  if (m_bucketNameHasBeenSet) {
    payload.WithString("bucketName", m_bucketName);
  }

  if (m_accessKeyIdHasBeenSet) {
    payload.WithString("accessKeyId", m_accessKeyId);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection DeleteBucketAccessKeyRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "Lightsail_20161128.DeleteBucketAccessKey"));
  return headers;
}
