﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/lightsail/model/GetDistributionMetricDataRequest.h>

#include <utility>

using namespace Aws::Lightsail::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String GetDistributionMetricDataRequest::SerializePayload() const {
  JsonValue payload;

  if (m_distributionNameHasBeenSet) {
    payload.WithString("distributionName", m_distributionName);
  }

  if (m_metricNameHasBeenSet) {
    payload.WithString("metricName", DistributionMetricNameMapper::GetNameForDistributionMetricName(m_metricName));
  }

  if (m_startTimeHasBeenSet) {
    payload.WithDouble("startTime", m_startTime.SecondsWithMSPrecision());
  }

  if (m_endTimeHasBeenSet) {
    payload.WithDouble("endTime", m_endTime.SecondsWithMSPrecision());
  }

  if (m_periodHasBeenSet) {
    payload.WithInteger("period", m_period);
  }

  if (m_unitHasBeenSet) {
    payload.WithString("unit", MetricUnitMapper::GetNameForMetricUnit(m_unit));
  }

  if (m_statisticsHasBeenSet) {
    Aws::Utils::Array<JsonValue> statisticsJsonList(m_statistics.size());
    for (unsigned statisticsIndex = 0; statisticsIndex < statisticsJsonList.GetLength(); ++statisticsIndex) {
      statisticsJsonList[statisticsIndex].AsString(MetricStatisticMapper::GetNameForMetricStatistic(m_statistics[statisticsIndex]));
    }
    payload.WithArray("statistics", std::move(statisticsJsonList));
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection GetDistributionMetricDataRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "Lightsail_20161128.GetDistributionMetricData"));
  return headers;
}
