﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/lightsail/model/StopRelationalDatabaseRequest.h>

#include <utility>

using namespace Aws::Lightsail::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String StopRelationalDatabaseRequest::SerializePayload() const {
  JsonValue payload;

  if (m_relationalDatabaseNameHasBeenSet) {
    payload.WithString("relationalDatabaseName", m_relationalDatabaseName);
  }

  if (m_relationalDatabaseSnapshotNameHasBeenSet) {
    payload.WithString("relationalDatabaseSnapshotName", m_relationalDatabaseSnapshotName);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection StopRelationalDatabaseRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "Lightsail_20161128.StopRelationalDatabase"));
  return headers;
}
