﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/logs/model/DeliveryDestination.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace CloudWatchLogs {
namespace Model {

DeliveryDestination::DeliveryDestination(JsonView jsonValue) { *this = jsonValue; }

DeliveryDestination& DeliveryDestination::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("name")) {
    m_name = jsonValue.GetString("name");
    m_nameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("arn")) {
    m_arn = jsonValue.GetString("arn");
    m_arnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("deliveryDestinationType")) {
    m_deliveryDestinationType =
        DeliveryDestinationTypeMapper::GetDeliveryDestinationTypeForName(jsonValue.GetString("deliveryDestinationType"));
    m_deliveryDestinationTypeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("outputFormat")) {
    m_outputFormat = OutputFormatMapper::GetOutputFormatForName(jsonValue.GetString("outputFormat"));
    m_outputFormatHasBeenSet = true;
  }
  if (jsonValue.ValueExists("deliveryDestinationConfiguration")) {
    m_deliveryDestinationConfiguration = jsonValue.GetObject("deliveryDestinationConfiguration");
    m_deliveryDestinationConfigurationHasBeenSet = true;
  }
  if (jsonValue.ValueExists("tags")) {
    Aws::Map<Aws::String, JsonView> tagsJsonMap = jsonValue.GetObject("tags").GetAllObjects();
    for (auto& tagsItem : tagsJsonMap) {
      m_tags[tagsItem.first] = tagsItem.second.AsString();
    }
    m_tagsHasBeenSet = true;
  }
  return *this;
}

JsonValue DeliveryDestination::Jsonize() const {
  JsonValue payload;

  if (m_nameHasBeenSet) {
    payload.WithString("name", m_name);
  }

  if (m_arnHasBeenSet) {
    payload.WithString("arn", m_arn);
  }

  if (m_deliveryDestinationTypeHasBeenSet) {
    payload.WithString("deliveryDestinationType",
                       DeliveryDestinationTypeMapper::GetNameForDeliveryDestinationType(m_deliveryDestinationType));
  }

  if (m_outputFormatHasBeenSet) {
    payload.WithString("outputFormat", OutputFormatMapper::GetNameForOutputFormat(m_outputFormat));
  }

  if (m_deliveryDestinationConfigurationHasBeenSet) {
    payload.WithObject("deliveryDestinationConfiguration", m_deliveryDestinationConfiguration.Jsonize());
  }

  if (m_tagsHasBeenSet) {
    JsonValue tagsJsonMap;
    for (auto& tagsItem : m_tags) {
      tagsJsonMap.WithString(tagsItem.first, tagsItem.second);
    }
    payload.WithObject("tags", std::move(tagsJsonMap));
  }

  return payload;
}

}  // namespace Model
}  // namespace CloudWatchLogs
}  // namespace Aws
