﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/logs/model/DescribeIndexPoliciesResult.h>

#include <utility>

using namespace Aws::CloudWatchLogs::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

DescribeIndexPoliciesResult::DescribeIndexPoliciesResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

DescribeIndexPoliciesResult& DescribeIndexPoliciesResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("indexPolicies")) {
    Aws::Utils::Array<JsonView> indexPoliciesJsonList = jsonValue.GetArray("indexPolicies");
    for (unsigned indexPoliciesIndex = 0; indexPoliciesIndex < indexPoliciesJsonList.GetLength(); ++indexPoliciesIndex) {
      m_indexPolicies.push_back(indexPoliciesJsonList[indexPoliciesIndex].AsObject());
    }
    m_indexPoliciesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("nextToken")) {
    m_nextToken = jsonValue.GetString("nextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
