﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/lookoutequipment/model/CreateLabelRequest.h>

#include <utility>

using namespace Aws::LookoutEquipment::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String CreateLabelRequest::SerializePayload() const {
  JsonValue payload;

  if (m_labelGroupNameHasBeenSet) {
    payload.WithString("LabelGroupName", m_labelGroupName);
  }

  if (m_startTimeHasBeenSet) {
    payload.WithDouble("StartTime", m_startTime.SecondsWithMSPrecision());
  }

  if (m_endTimeHasBeenSet) {
    payload.WithDouble("EndTime", m_endTime.SecondsWithMSPrecision());
  }

  if (m_ratingHasBeenSet) {
    payload.WithString("Rating", LabelRatingMapper::GetNameForLabelRating(m_rating));
  }

  if (m_faultCodeHasBeenSet) {
    payload.WithString("FaultCode", m_faultCode);
  }

  if (m_notesHasBeenSet) {
    payload.WithString("Notes", m_notes);
  }

  if (m_equipmentHasBeenSet) {
    payload.WithString("Equipment", m_equipment);
  }

  if (m_clientTokenHasBeenSet) {
    payload.WithString("ClientToken", m_clientToken);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection CreateLabelRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "AWSLookoutEquipmentFrontendService.CreateLabel"));
  return headers;
}
