﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/lookoutequipment/model/DescribeModelRequest.h>

#include <utility>

using namespace Aws::LookoutEquipment::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String DescribeModelRequest::SerializePayload() const {
  JsonValue payload;

  if (m_modelNameHasBeenSet) {
    payload.WithString("ModelName", m_modelName);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection DescribeModelRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "AWSLookoutEquipmentFrontendService.DescribeModel"));
  return headers;
}
