﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/lookoutequipment/model/MissingCompleteSensorData.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace LookoutEquipment {
namespace Model {

MissingCompleteSensorData::MissingCompleteSensorData(JsonView jsonValue) { *this = jsonValue; }

MissingCompleteSensorData& MissingCompleteSensorData::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("AffectedSensorCount")) {
    m_affectedSensorCount = jsonValue.GetInteger("AffectedSensorCount");
    m_affectedSensorCountHasBeenSet = true;
  }
  return *this;
}

JsonValue MissingCompleteSensorData::Jsonize() const {
  JsonValue payload;

  if (m_affectedSensorCountHasBeenSet) {
    payload.WithInteger("AffectedSensorCount", m_affectedSensorCount);
  }

  return payload;
}

}  // namespace Model
}  // namespace LookoutEquipment
}  // namespace Aws
