﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/lookoutequipment/model/StopRetrainingSchedulerRequest.h>

#include <utility>

using namespace Aws::LookoutEquipment::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String StopRetrainingSchedulerRequest::SerializePayload() const {
  JsonValue payload;

  if (m_modelNameHasBeenSet) {
    payload.WithString("ModelName", m_modelName);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection StopRetrainingSchedulerRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "AWSLookoutEquipmentFrontendService.StopRetrainingScheduler"));
  return headers;
}
