﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/machinelearning/model/DeleteDataSourceRequest.h>

#include <utility>

using namespace Aws::MachineLearning::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String DeleteDataSourceRequest::SerializePayload() const {
  JsonValue payload;

  if (m_dataSourceIdHasBeenSet) {
    payload.WithString("DataSourceId", m_dataSourceId);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection DeleteDataSourceRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "AmazonML_20141212.DeleteDataSource"));
  return headers;
}
