﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/machinelearning/model/GetMLModelResult.h>

#include <utility>

using namespace Aws::MachineLearning::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

GetMLModelResult::GetMLModelResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

GetMLModelResult& GetMLModelResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("MLModelId")) {
    m_mLModelId = jsonValue.GetString("MLModelId");
    m_mLModelIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("TrainingDataSourceId")) {
    m_trainingDataSourceId = jsonValue.GetString("TrainingDataSourceId");
    m_trainingDataSourceIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("CreatedByIamUser")) {
    m_createdByIamUser = jsonValue.GetString("CreatedByIamUser");
    m_createdByIamUserHasBeenSet = true;
  }
  if (jsonValue.ValueExists("CreatedAt")) {
    m_createdAt = jsonValue.GetDouble("CreatedAt");
    m_createdAtHasBeenSet = true;
  }
  if (jsonValue.ValueExists("LastUpdatedAt")) {
    m_lastUpdatedAt = jsonValue.GetDouble("LastUpdatedAt");
    m_lastUpdatedAtHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Name")) {
    m_name = jsonValue.GetString("Name");
    m_nameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Status")) {
    m_status = EntityStatusMapper::GetEntityStatusForName(jsonValue.GetString("Status"));
    m_statusHasBeenSet = true;
  }
  if (jsonValue.ValueExists("SizeInBytes")) {
    m_sizeInBytes = jsonValue.GetInt64("SizeInBytes");
    m_sizeInBytesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("EndpointInfo")) {
    m_endpointInfo = jsonValue.GetObject("EndpointInfo");
    m_endpointInfoHasBeenSet = true;
  }
  if (jsonValue.ValueExists("TrainingParameters")) {
    Aws::Map<Aws::String, JsonView> trainingParametersJsonMap = jsonValue.GetObject("TrainingParameters").GetAllObjects();
    for (auto& trainingParametersItem : trainingParametersJsonMap) {
      m_trainingParameters[trainingParametersItem.first] = trainingParametersItem.second.AsString();
    }
    m_trainingParametersHasBeenSet = true;
  }
  if (jsonValue.ValueExists("InputDataLocationS3")) {
    m_inputDataLocationS3 = jsonValue.GetString("InputDataLocationS3");
    m_inputDataLocationS3HasBeenSet = true;
  }
  if (jsonValue.ValueExists("MLModelType")) {
    m_mLModelType = MLModelTypeMapper::GetMLModelTypeForName(jsonValue.GetString("MLModelType"));
    m_mLModelTypeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("ScoreThreshold")) {
    m_scoreThreshold = jsonValue.GetDouble("ScoreThreshold");
    m_scoreThresholdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("ScoreThresholdLastUpdatedAt")) {
    m_scoreThresholdLastUpdatedAt = jsonValue.GetDouble("ScoreThresholdLastUpdatedAt");
    m_scoreThresholdLastUpdatedAtHasBeenSet = true;
  }
  if (jsonValue.ValueExists("LogUri")) {
    m_logUri = jsonValue.GetString("LogUri");
    m_logUriHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Message")) {
    m_message = jsonValue.GetString("Message");
    m_messageHasBeenSet = true;
  }
  if (jsonValue.ValueExists("ComputeTime")) {
    m_computeTime = jsonValue.GetInt64("ComputeTime");
    m_computeTimeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("FinishedAt")) {
    m_finishedAt = jsonValue.GetDouble("FinishedAt");
    m_finishedAtHasBeenSet = true;
  }
  if (jsonValue.ValueExists("StartedAt")) {
    m_startedAt = jsonValue.GetDouble("StartedAt");
    m_startedAtHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Recipe")) {
    m_recipe = jsonValue.GetString("Recipe");
    m_recipeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Schema")) {
    m_schema = jsonValue.GetString("Schema");
    m_schemaHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
