﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/mailmanager/model/GetArchiveMessageContentRequest.h>

#include <utility>

using namespace Aws::MailManager::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String GetArchiveMessageContentRequest::SerializePayload() const {
  JsonValue payload;

  if (m_archivedMessageIdHasBeenSet) {
    payload.WithString("ArchivedMessageId", m_archivedMessageId);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection GetArchiveMessageContentRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "MailManagerSvc.GetArchiveMessageContent"));
  return headers;
}
