﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/mailmanager/model/IngressTlsProtocolToEvaluate.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace MailManager {
namespace Model {

IngressTlsProtocolToEvaluate::IngressTlsProtocolToEvaluate(JsonView jsonValue) { *this = jsonValue; }

IngressTlsProtocolToEvaluate& IngressTlsProtocolToEvaluate::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("Attribute")) {
    m_attribute = IngressTlsAttributeMapper::GetIngressTlsAttributeForName(jsonValue.GetString("Attribute"));
    m_attributeHasBeenSet = true;
  }
  return *this;
}

JsonValue IngressTlsProtocolToEvaluate::Jsonize() const {
  JsonValue payload;

  if (m_attributeHasBeenSet) {
    payload.WithString("Attribute", IngressTlsAttributeMapper::GetNameForIngressTlsAttribute(m_attribute));
  }

  return payload;
}

}  // namespace Model
}  // namespace MailManager
}  // namespace Aws
