﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/mailmanager/model/ListMembersOfAddressListRequest.h>

#include <utility>

using namespace Aws::MailManager::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String ListMembersOfAddressListRequest::SerializePayload() const {
  JsonValue payload;

  if (m_addressListIdHasBeenSet) {
    payload.WithString("AddressListId", m_addressListId);
  }

  if (m_filterHasBeenSet) {
    payload.WithObject("Filter", m_filter.Jsonize());
  }

  if (m_nextTokenHasBeenSet) {
    payload.WithString("NextToken", m_nextToken);
  }

  if (m_pageSizeHasBeenSet) {
    payload.WithInteger("PageSize", m_pageSize);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection ListMembersOfAddressListRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "MailManagerSvc.ListMembersOfAddressList"));
  return headers;
}
