﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/mailmanager/model/Rule.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace MailManager {
namespace Model {

Rule::Rule(JsonView jsonValue) { *this = jsonValue; }

Rule& Rule::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("Name")) {
    m_name = jsonValue.GetString("Name");
    m_nameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Conditions")) {
    Aws::Utils::Array<JsonView> conditionsJsonList = jsonValue.GetArray("Conditions");
    for (unsigned conditionsIndex = 0; conditionsIndex < conditionsJsonList.GetLength(); ++conditionsIndex) {
      m_conditions.push_back(conditionsJsonList[conditionsIndex].AsObject());
    }
    m_conditionsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Unless")) {
    Aws::Utils::Array<JsonView> unlessJsonList = jsonValue.GetArray("Unless");
    for (unsigned unlessIndex = 0; unlessIndex < unlessJsonList.GetLength(); ++unlessIndex) {
      m_unless.push_back(unlessJsonList[unlessIndex].AsObject());
    }
    m_unlessHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Actions")) {
    Aws::Utils::Array<JsonView> actionsJsonList = jsonValue.GetArray("Actions");
    for (unsigned actionsIndex = 0; actionsIndex < actionsJsonList.GetLength(); ++actionsIndex) {
      m_actions.push_back(actionsJsonList[actionsIndex].AsObject());
    }
    m_actionsHasBeenSet = true;
  }
  return *this;
}

JsonValue Rule::Jsonize() const {
  JsonValue payload;

  if (m_nameHasBeenSet) {
    payload.WithString("Name", m_name);
  }

  if (m_conditionsHasBeenSet) {
    Aws::Utils::Array<JsonValue> conditionsJsonList(m_conditions.size());
    for (unsigned conditionsIndex = 0; conditionsIndex < conditionsJsonList.GetLength(); ++conditionsIndex) {
      conditionsJsonList[conditionsIndex].AsObject(m_conditions[conditionsIndex].Jsonize());
    }
    payload.WithArray("Conditions", std::move(conditionsJsonList));
  }

  if (m_unlessHasBeenSet) {
    Aws::Utils::Array<JsonValue> unlessJsonList(m_unless.size());
    for (unsigned unlessIndex = 0; unlessIndex < unlessJsonList.GetLength(); ++unlessIndex) {
      unlessJsonList[unlessIndex].AsObject(m_unless[unlessIndex].Jsonize());
    }
    payload.WithArray("Unless", std::move(unlessJsonList));
  }

  if (m_actionsHasBeenSet) {
    Aws::Utils::Array<JsonValue> actionsJsonList(m_actions.size());
    for (unsigned actionsIndex = 0; actionsIndex < actionsJsonList.GetLength(); ++actionsIndex) {
      actionsJsonList[actionsIndex].AsObject(m_actions[actionsIndex].Jsonize());
    }
    payload.WithArray("Actions", std::move(actionsJsonList));
  }

  return payload;
}

}  // namespace Model
}  // namespace MailManager
}  // namespace Aws
