﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/mailmanager/model/SavedAddress.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace MailManager {
namespace Model {

SavedAddress::SavedAddress(JsonView jsonValue) { *this = jsonValue; }

SavedAddress& SavedAddress::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("Address")) {
    m_address = jsonValue.GetString("Address");
    m_addressHasBeenSet = true;
  }
  if (jsonValue.ValueExists("CreatedTimestamp")) {
    m_createdTimestamp = jsonValue.GetDouble("CreatedTimestamp");
    m_createdTimestampHasBeenSet = true;
  }
  return *this;
}

JsonValue SavedAddress::Jsonize() const {
  JsonValue payload;

  if (m_addressHasBeenSet) {
    payload.WithString("Address", m_address);
  }

  if (m_createdTimestampHasBeenSet) {
    payload.WithDouble("CreatedTimestamp", m_createdTimestamp.SecondsWithMSPrecision());
  }

  return payload;
}

}  // namespace Model
}  // namespace MailManager
}  // namespace Aws
