﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/managedblockchain-query/model/GetAssetContractRequest.h>

#include <utility>

using namespace Aws::ManagedBlockchainQuery::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String GetAssetContractRequest::SerializePayload() const {
  JsonValue payload;

  if (m_contractIdentifierHasBeenSet) {
    payload.WithObject("contractIdentifier", m_contractIdentifier.Jsonize());
  }

  return payload.View().WriteReadable();
}
