﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/marketplace-agreement/model/SupportTerm.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace AgreementService {
namespace Model {

SupportTerm::SupportTerm(JsonView jsonValue) { *this = jsonValue; }

SupportTerm& SupportTerm::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("type")) {
    m_type = jsonValue.GetString("type");
    m_typeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("refundPolicy")) {
    m_refundPolicy = jsonValue.GetString("refundPolicy");
    m_refundPolicyHasBeenSet = true;
  }
  return *this;
}

JsonValue SupportTerm::Jsonize() const {
  JsonValue payload;

  if (m_typeHasBeenSet) {
    payload.WithString("type", m_type);
  }

  if (m_refundPolicyHasBeenSet) {
    payload.WithString("refundPolicy", m_refundPolicy);
  }

  return payload;
}

}  // namespace Model
}  // namespace AgreementService
}  // namespace Aws
