﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/mediapackage-vod/model/HlsEncryption.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace MediaPackageVod {
namespace Model {

HlsEncryption::HlsEncryption(JsonView jsonValue) { *this = jsonValue; }

HlsEncryption& HlsEncryption::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("constantInitializationVector")) {
    m_constantInitializationVector = jsonValue.GetString("constantInitializationVector");
    m_constantInitializationVectorHasBeenSet = true;
  }
  if (jsonValue.ValueExists("encryptionMethod")) {
    m_encryptionMethod = EncryptionMethodMapper::GetEncryptionMethodForName(jsonValue.GetString("encryptionMethod"));
    m_encryptionMethodHasBeenSet = true;
  }
  if (jsonValue.ValueExists("spekeKeyProvider")) {
    m_spekeKeyProvider = jsonValue.GetObject("spekeKeyProvider");
    m_spekeKeyProviderHasBeenSet = true;
  }
  return *this;
}

JsonValue HlsEncryption::Jsonize() const {
  JsonValue payload;

  if (m_constantInitializationVectorHasBeenSet) {
    payload.WithString("constantInitializationVector", m_constantInitializationVector);
  }

  if (m_encryptionMethodHasBeenSet) {
    payload.WithString("encryptionMethod", EncryptionMethodMapper::GetNameForEncryptionMethod(m_encryptionMethod));
  }

  if (m_spekeKeyProviderHasBeenSet) {
    payload.WithObject("spekeKeyProvider", m_spekeKeyProvider.Jsonize());
  }

  return payload;
}

}  // namespace Model
}  // namespace MediaPackageVod
}  // namespace Aws
