﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/mediapackage-vod/model/ListPackagingGroupsResult.h>

#include <utility>

using namespace Aws::MediaPackageVod::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListPackagingGroupsResult::ListPackagingGroupsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListPackagingGroupsResult& ListPackagingGroupsResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("nextToken")) {
    m_nextToken = jsonValue.GetString("nextToken");
    m_nextTokenHasBeenSet = true;
  }
  if (jsonValue.ValueExists("packagingGroups")) {
    Aws::Utils::Array<JsonView> packagingGroupsJsonList = jsonValue.GetArray("packagingGroups");
    for (unsigned packagingGroupsIndex = 0; packagingGroupsIndex < packagingGroupsJsonList.GetLength(); ++packagingGroupsIndex) {
      m_packagingGroups.push_back(packagingGroupsJsonList[packagingGroupsIndex].AsObject());
    }
    m_packagingGroupsHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
