﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/mediastore/model/PutMetricPolicyRequest.h>

#include <utility>

using namespace Aws::MediaStore::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String PutMetricPolicyRequest::SerializePayload() const {
  JsonValue payload;

  if (m_containerNameHasBeenSet) {
    payload.WithString("ContainerName", m_containerName);
  }

  if (m_metricPolicyHasBeenSet) {
    payload.WithObject("MetricPolicy", m_metricPolicy.Jsonize());
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection PutMetricPolicyRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "MediaStore_20170901.PutMetricPolicy"));
  return headers;
}
