﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/mturk-requester/model/GetQualificationScoreRequest.h>

#include <utility>

using namespace Aws::MTurk::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String GetQualificationScoreRequest::SerializePayload() const {
  JsonValue payload;

  if (m_qualificationTypeIdHasBeenSet) {
    payload.WithString("QualificationTypeId", m_qualificationTypeId);
  }

  if (m_workerIdHasBeenSet) {
    payload.WithString("WorkerId", m_workerId);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection GetQualificationScoreRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "MTurkRequesterServiceV20170117.GetQualificationScore"));
  return headers;
}
