﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/mturk-requester/model/ListWorkersWithQualificationTypeRequest.h>

#include <utility>

using namespace Aws::MTurk::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String ListWorkersWithQualificationTypeRequest::SerializePayload() const {
  JsonValue payload;

  if (m_qualificationTypeIdHasBeenSet) {
    payload.WithString("QualificationTypeId", m_qualificationTypeId);
  }

  if (m_statusHasBeenSet) {
    payload.WithString("Status", QualificationStatusMapper::GetNameForQualificationStatus(m_status));
  }

  if (m_nextTokenHasBeenSet) {
    payload.WithString("NextToken", m_nextToken);
  }

  if (m_maxResultsHasBeenSet) {
    payload.WithInteger("MaxResults", m_maxResults);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection ListWorkersWithQualificationTypeRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "MTurkRequesterServiceV20170117.ListWorkersWithQualificationType"));
  return headers;
}
