﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/mwaa-serverless/model/ListWorkflowVersionsResult.h>

#include <utility>

using namespace Aws::MWAAServerless::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListWorkflowVersionsResult::ListWorkflowVersionsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListWorkflowVersionsResult& ListWorkflowVersionsResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("WorkflowVersions")) {
    Aws::Utils::Array<JsonView> workflowVersionsJsonList = jsonValue.GetArray("WorkflowVersions");
    for (unsigned workflowVersionsIndex = 0; workflowVersionsIndex < workflowVersionsJsonList.GetLength(); ++workflowVersionsIndex) {
      m_workflowVersions.push_back(workflowVersionsJsonList[workflowVersionsIndex].AsObject());
    }
    m_workflowVersionsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("NextToken")) {
    m_nextToken = jsonValue.GetString("NextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
