﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/neptune/model/DescribeEventCategoriesRequest.h>

using namespace Aws::Neptune::Model;
using namespace Aws::Utils;

Aws::String DescribeEventCategoriesRequest::SerializePayload() const {
  Aws::StringStream ss;
  ss << "Action=DescribeEventCategories&";
  if (m_sourceTypeHasBeenSet) {
    ss << "SourceType=" << StringUtils::URLEncode(m_sourceType.c_str()) << "&";
  }

  if (m_filtersHasBeenSet) {
    if (m_filters.empty()) {
      ss << "Filters=&";
    } else {
      unsigned filtersCount = 1;
      for (auto& item : m_filters) {
        item.OutputToStream(ss, "Filters.Filter.", filtersCount, "");
        filtersCount++;
      }
    }
  }

  ss << "Version=2014-10-31";
  return ss.str();
}

void DescribeEventCategoriesRequest::DumpBodyToUrl(Aws::Http::URI& uri) const { uri.SetQueryString(SerializePayload()); }
