﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/logging/LogMacros.h>
#include <aws/core/utils/xml/XmlSerializer.h>
#include <aws/neptune/model/DescribeGlobalClustersResult.h>

#include <utility>

using namespace Aws::Neptune::Model;
using namespace Aws::Utils::Xml;
using namespace Aws::Utils::Logging;
using namespace Aws::Utils;
using namespace Aws;

DescribeGlobalClustersResult::DescribeGlobalClustersResult(const Aws::AmazonWebServiceResult<XmlDocument>& result) { *this = result; }

DescribeGlobalClustersResult& DescribeGlobalClustersResult::operator=(const Aws::AmazonWebServiceResult<XmlDocument>& result) {
  const XmlDocument& xmlDocument = result.GetPayload();
  XmlNode rootNode = xmlDocument.GetRootElement();
  XmlNode resultNode = rootNode;
  if (!rootNode.IsNull() && (rootNode.GetName() != "DescribeGlobalClustersResult")) {
    resultNode = rootNode.FirstChild("DescribeGlobalClustersResult");
  }

  if (!resultNode.IsNull()) {
    XmlNode markerNode = resultNode.FirstChild("Marker");
    if (!markerNode.IsNull()) {
      m_marker = Aws::Utils::Xml::DecodeEscapedXmlText(markerNode.GetText());
      m_markerHasBeenSet = true;
    }
    XmlNode globalClustersNode = resultNode.FirstChild("GlobalClusters");
    if (!globalClustersNode.IsNull()) {
      XmlNode globalClustersMember = globalClustersNode.FirstChild("GlobalClusterMember");
      m_globalClustersHasBeenSet = !globalClustersMember.IsNull();
      while (!globalClustersMember.IsNull()) {
        m_globalClusters.push_back(globalClustersMember);
        globalClustersMember = globalClustersMember.NextNode("GlobalClusterMember");
      }

      m_globalClustersHasBeenSet = true;
    }
  }

  if (!rootNode.IsNull()) {
    XmlNode responseMetadataNode = rootNode.FirstChild("ResponseMetadata");
    m_responseMetadata = responseMetadataNode;
    m_responseMetadataHasBeenSet = true;
    AWS_LOGSTREAM_DEBUG("Aws::Neptune::Model::DescribeGlobalClustersResult", "x-amzn-request-id: " << m_responseMetadata.GetRequestId());
  }
  return *this;
}
