﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/networkflowmonitor/model/MonitorRemoteResource.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace NetworkFlowMonitor {
namespace Model {

MonitorRemoteResource::MonitorRemoteResource(JsonView jsonValue) { *this = jsonValue; }

MonitorRemoteResource& MonitorRemoteResource::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("type")) {
    m_type = MonitorRemoteResourceTypeMapper::GetMonitorRemoteResourceTypeForName(jsonValue.GetString("type"));
    m_typeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("identifier")) {
    m_identifier = jsonValue.GetString("identifier");
    m_identifierHasBeenSet = true;
  }
  return *this;
}

JsonValue MonitorRemoteResource::Jsonize() const {
  JsonValue payload;

  if (m_typeHasBeenSet) {
    payload.WithString("type", MonitorRemoteResourceTypeMapper::GetNameForMonitorRemoteResourceType(m_type));
  }

  if (m_identifierHasBeenSet) {
    payload.WithString("identifier", m_identifier);
  }

  return payload;
}

}  // namespace Model
}  // namespace NetworkFlowMonitor
}  // namespace Aws
