﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/partnercentral-selling/model/CustomerProjectsContext.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace PartnerCentralSelling {
namespace Model {

CustomerProjectsContext::CustomerProjectsContext(JsonView jsonValue) { *this = jsonValue; }

CustomerProjectsContext& CustomerProjectsContext::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("Customer")) {
    m_customer = jsonValue.GetObject("Customer");
    m_customerHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Project")) {
    m_project = jsonValue.GetObject("Project");
    m_projectHasBeenSet = true;
  }
  return *this;
}

JsonValue CustomerProjectsContext::Jsonize() const {
  JsonValue payload;

  if (m_customerHasBeenSet) {
    payload.WithObject("Customer", m_customer.Jsonize());
  }

  if (m_projectHasBeenSet) {
    payload.WithObject("Project", m_project.Jsonize());
  }

  return payload;
}

}  // namespace Model
}  // namespace PartnerCentralSelling
}  // namespace Aws
