﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/partnercentral-selling/model/ListEngagementByAcceptingInvitationTasksResult.h>

#include <utility>

using namespace Aws::PartnerCentralSelling::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListEngagementByAcceptingInvitationTasksResult::ListEngagementByAcceptingInvitationTasksResult(
    const Aws::AmazonWebServiceResult<JsonValue>& result) {
  *this = result;
}

ListEngagementByAcceptingInvitationTasksResult& ListEngagementByAcceptingInvitationTasksResult::operator=(
    const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("TaskSummaries")) {
    Aws::Utils::Array<JsonView> taskSummariesJsonList = jsonValue.GetArray("TaskSummaries");
    for (unsigned taskSummariesIndex = 0; taskSummariesIndex < taskSummariesJsonList.GetLength(); ++taskSummariesIndex) {
      m_taskSummaries.push_back(taskSummariesJsonList[taskSummariesIndex].AsObject());
    }
    m_taskSummariesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("NextToken")) {
    m_nextToken = jsonValue.GetString("NextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
