﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/payment-cryptography/model/DeleteKeyRequest.h>

#include <utility>

using namespace Aws::PaymentCryptography::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String DeleteKeyRequest::SerializePayload() const {
  JsonValue payload;

  if (m_keyIdentifierHasBeenSet) {
    payload.WithString("KeyIdentifier", m_keyIdentifier);
  }

  if (m_deleteKeyInDaysHasBeenSet) {
    payload.WithInteger("DeleteKeyInDays", m_deleteKeyInDays);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection DeleteKeyRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "PaymentCryptographyControlPlane.DeleteKey"));
  return headers;
}
