﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/pca-connector-scep/model/CreateChallengeRequest.h>

#include <utility>

using namespace Aws::PcaConnectorScep::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String CreateChallengeRequest::SerializePayload() const {
  JsonValue payload;

  if (m_connectorArnHasBeenSet) {
    payload.WithString("ConnectorArn", m_connectorArn);
  }

  if (m_clientTokenHasBeenSet) {
    payload.WithString("ClientToken", m_clientToken);
  }

  if (m_tagsHasBeenSet) {
    JsonValue tagsJsonMap;
    for (auto& tagsItem : m_tags) {
      tagsJsonMap.WithString(tagsItem.first, tagsItem.second);
    }
    payload.WithObject("Tags", std::move(tagsJsonMap));
  }

  return payload.View().WriteReadable();
}
