﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/personalize-events/model/Action.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace PersonalizeEvents {
namespace Model {

Action::Action(JsonView jsonValue) { *this = jsonValue; }

Action& Action::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("actionId")) {
    m_actionId = jsonValue.GetString("actionId");
    m_actionIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("properties")) {
    m_properties = jsonValue.GetString("properties");
    m_propertiesHasBeenSet = true;
  }
  return *this;
}

JsonValue Action::Jsonize() const {
  JsonValue payload;

  if (m_actionIdHasBeenSet) {
    payload.WithString("actionId", m_actionId);
  }

  if (m_propertiesHasBeenSet) {
    payload.WithString("properties", m_properties);
  }

  return payload;
}

}  // namespace Model
}  // namespace PersonalizeEvents
}  // namespace Aws
